# Configuration: Automatic Configuration Restoring

This readme describes how to use the sample to create a startup sample. In this example, we demonstrate, how to store the current configuration dynamically after a change into the persistence, so it can be restored when booting the server the next time. This may be required in environments, where the configuratiuon may not persist, but the persistence itself does.

## Activate the included plugin

A compiled version of the plugin is made available as `configuration.automaticconfigrestore.sample.zip`. To test this plugin, you need to copy the plugin ZIP file into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details.

## Build the plugin

The following steps must be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some modifications, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

To build this plugin the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example, it is `configuration.automaticconfigrestore.sample.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `configuration.automaticconfigrestore.sample.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configure the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin as well as any other build system.

